#cloud-config
preserve_hostname: true
manage_etc_hosts: false
bootcmd:
  - cloud-init-per instance my_set_hostname sh -xc "echo "${service}-$INSTANCE_ID" | sed -e 's/-i-/-/g' > /etc/hostname; hostname -F /etc/hostname"
  - cloud-init-per instance my_etc_hosts sh -xc "sed -i -e '/^127.0.1.1/d' /etc/hosts; echo 127.0.1.1 $(cat /etc/hostname).${dns_region}.${dns_zone} $(cat /etc/hostname) >> /etc/hosts"
runcmd:
  - mkdir -p /etc/facter/facts.d
${facts}
  - |
      snap install amazon-ssm-agent            > /dev/ttyS0 2>&1
      snap start amazon-ssm-agent              > /dev/ttyS0 2>&1
      curl https://deb.internal.justin.tv/artifactory/api/gpg/key/public | apt-key add - > /dev/ttyS0 2>&1
      . /etc/lsb-release
      echo "deb [arch=amd64] http://packages.internal.justin.tv/artifactory/ip-$${DISTRIB_CODENAME}-twitch $${DISTRIB_CODENAME} main" > /etc/apt/sources.list.d/twitch.list
      apt update                               > /dev/ttyS0 2>&1
      apt install -y facter ${packages}        > /dev/ttyS0 2>&1
      apt upgrade -y                           > /dev/ttyS0 2>&1
      ${puppet}                                > /var/log/first-puppet.log 2>&1
      ${run_scripts}
      reboot
${files}
