## Input arguments, required

variable "service" {}
variable "role" {}
variable "environment" {}
variable "owner" {}

variable "vpc_security_group_ids" {
  type = list(string)
}

variable "ami" {
  default = "xenial"
}

## Input arguments, optional
# By default make a new instance_profile - supply a profile name to use an
#  existing one
variable "instance_profile" {
  default = "create"
}

variable "instance_type" {
  default = "m4.large"
}

variable "run_scripts" {
  default     = "echo"
  description = "Optional script to run."
}

variable "puppet" {
  default = ""
} # as opposed to puppet

variable "root_block_device_size" {
  default = 32
}

variable "additional_facts" {
  default = []
  type    = list(string)
}

variable "additional_tags" {
  default = {}
  type    = map
}

# Used for Chasqui tags
variable "chasqui_service" {
  default = ""
}

variable "chasqui_stage" {
  default = ""
}

# prod.systems.twitch.a2z.com is our default. Makes host names like:
# cluster-name-instanceid.us-west-2.prod.systems.twitch.a2z.com
# - stage.systems.twitch.a2z.com Z28FIFQ3YEU8LW (twitch-central-dev)
# -   dev.systems.twitch.a2z.com ZJO286TVG0E2F  (twitch-central-dev)
#
variable "r53_zone_id" {
  default = "Z2SYORN9EDMU4L"
}

## Input arguments, conflicting
# Everything in this section is either handled by the private_ip map
#  -or-
# will need to be set. Do not set both.

# Static IP mappings, should be subnet-id = "IPV4"
variable "private_ip" {
  type = map

  default = {}
}

# subnet id list - if more than one, instances will be deployed modulo the list
variable "subnet_ids" {
  type    = list(string)
  default = []
}

variable "instance_count" {
  default = 0
}

# Outputs
output "instance_ids" {
  value = aws_instance.instance.*.id
}

output "iam_role_id" {
  value = aws_iam_role.iam_role.*.id
}

output "fqdns" {
  value = aws_route53_record.instance_dns.*.fqdn
}

output "iam_role_name" {
  value = aws_iam_role.iam_role.*.name
}
