data "template_file" "es_metrics_runner" {
	template = "${file("${path.module}/es-metrics-launch.sh.tmpl")}"

	vars {
		es_elb = "${var.service}.${var.environment}.us-west2.justin.tv"
		puppet_twitch_role = "${var.service}"
		puppet_cluster = "${var.service}"
	        puppet_environment = "${lookup(map("prod", "production", "dev", "development"), var.environment, "development")}"

                syslog_host = "grand-central-syslog.prod.us-west2.justin.tv"
                syslog_port = 6514
                syslog_tag = "${var.service}_${var.environment}_diamond"
                syslog_facility = "local0"
                image_version = "${var.diamond_image_version}"
	}
}

data "template_cloudinit_config" "es_metrics_runner_userdata" {
  gzip          = false
  base64_encode = false

  part {
    content = "${data.template_file.es_cloudinit.rendered}"
    content_type = "text/cloud-config"
  }
  part {
    content = "${data.template_file.es_metrics_runner.rendered}"
    content_type = "text/x-shellscript"
  }
}

resource "aws_launch_configuration" "es_metrics_runner" {
  name_prefix = "${var.service}-es-metrics-launch-configuration-"
  lifecycle {
    create_before_destroy = true
  }
  image_id        = "ami-02294c62"
  instance_type   = "t2.micro"
  security_groups = ["${var.security_groups}"]
  
  associate_public_ip_address = false
  
  iam_instance_profile = "${aws_iam_instance_profile.instance_profile.id}"
  
  user_data = "${data.template_cloudinit_config.es_metrics_runner_userdata.rendered}"
}

resource "aws_autoscaling_group" "es_metrics_runner" {
  name = "${var.service}-es-metrics-asg"
  availability_zones = ["us-west-2a", "us-west-2b", "us-west-2c"]
  wait_for_capacity_timeout = 0
  max_size = 21
  min_size = 1
  health_check_grace_period = 1200
  health_check_type = "EC2"
  desired_capacity = 1
  force_delete = true
  vpc_zone_identifier = ["${var.subnet_ids}"]
  
  launch_configuration = "${aws_launch_configuration.es_metrics_runner.name}"
  tag {
    key = "Service"
    value = "${var.owner}/${var.service}-es-metrics"
    propagate_at_launch = true
  }
  tag {
    key = "Name"
    value = "${var.service}-es-metrics"
    propagate_at_launch = true
  }
  tag {
    key = "Owner"
    value = "${var.owner_email}"
    propagate_at_launch = true
  }
  tag {
    key = "Environment"
    value = "${var.environment}"
    propagate_at_launch = true
  }
  
  lifecycle {
    create_before_destroy = true
  }
}
