provider "aws" {
  alias   = "${var.account}"
  region  = "${var.region}"
  profile = "${var.account}"
}

data "aws_iam_policy_document" "s3_codedeploy" {
  provider    = "aws.${var.account}"
  statement {
    actions   = [
      "s3:Get*",
      "s3:List*"
    ]
    resources = [
      "arn:aws:s3:::deployments-${var.service_name}",
      "arn:aws:s3:::deployments-${var.service_name}*",
      "arn:aws:s3:::aws-codedeploy-*/*"
    ]
    effect = "Allow"
  }
}

resource "aws_iam_policy" "s3_codedeploy" {
  provider    = "aws.${var.account}"
  name        = "${var.service_name}-s3-codedeploy"
  path        = "/"
  description = "Allows access to s3 deploy artifacts"
  count       = "${var.policy_arn == "create" ? 1 : 0}"
  policy      = "${data.aws_iam_policy_document.s3_codedeploy.json}"
}

# This is in 2 resources due to always trying to eval the aws_iam_policy in the if and failing if the above is set to 0
resource "aws_iam_role_policy_attachment" "s3-codedeploy" {
  provider   = "aws.${var.account}"
  role       = "${var.instance_profile}"
  policy_arn = "${aws_iam_policy.s3_codedeploy.arn }"
  count      = "${var.policy_arn == "create" ? 1 : 0}"
}

resource "aws_iam_role_policy_attachment" "s3-codedeploy_existing" {
  provider   = "aws.${var.account}"
  role       = "${var.instance_profile}"
  policy_arn = "${var.policy_arn}"
  count      = "${var.policy_arn == "create" ? 0 : 1}"
}

resource "aws_iam_role_policy_attachment" "codedeploy" {
  provider   = "aws.${var.account}"
  role       = "${var.instance_profile}"
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSCodeDeployRole"
}
