# CodeDeploy Registration Policy Document
This module exposes an IAM policy document with the statement to allow CodeDeploy-related actions.

Use the policy provided by this module by attaching it to your intended IAM Role.

## Sample usage:
```
module "codedeploy_policy" {
  source  = "git::ssh://git@git-aws.internal.justin.tv/terraform-modules/codedeploy-registration-policy.git"
}

resource "aws_iam_policy_attachment" "test_attachment" {
  name       = "test-attachment"
  roles      = ["${aws_iam_role.test_role.name}"]
  policy_arn = "${module.codedeploy_policy.arn}"
}
```
