data "aws_iam_policy_document" "codedeploy_policy_document" {
  statement {
    actions = [
      "codedeploy:*",
      "kms:*",
      "s3:*",
      "iam:PassRole"
    ]
    resources = [
      "*"
    ]
    effect = "Allow"
  }
  statement {
    actions = [
      "logs:DescribeLogGroups"
    ]
    resources = [
      "arn:aws:logs:*:*:log-group:*"
    ]
    effect = "Allow"
  }
  statement {
    actions = [
      "logs:DescribeLogStreams"
    ]
    resources = [
      "arn:aws:logs:*:*:log-group:staged-deploy/winc:log-stream:*"
    ]
    effect = "Allow"
  }
  statement {
    actions = [
      "logs:CreateLogStream",
      "logs:PutLogEvents"
    ]
    resources = [
      "arn:aws:logs:*:*:log-group:staged-deploy/winc",
      "arn:aws:logs:*:*:log-group:staged-deploy/winc:log-stream:*"
    ]
    effect = "Allow"
  }
}

resource "aws_iam_policy" "codedeploy_policy" {
  name   = "codedeploy-registration-policy"
  path   = "/"
  policy = "${data.aws_iam_policy_document.codedeploy_policy_document.json}"
}

output "arn" {
  value = "${aws_iam_policy.codedeploy_policy.arn}"
}
