# Required
variable "account" {}

variable "environment" {}
variable "service" {}
variable "lb_port" {}
variable "instance_port" {}
variable "protocol" {}
variable "ssl_arn" {}

variable "subnets" {
  type = "list"
}

variable "security_groups" {
  type = "list"
}

variable "instances" {
  type = "list"
}

# Optional
variable "region" {
  default = "us-west-2"
}

# Utility vars
# For use with creating FQDNs
variable "env_shortname" {
  type = "map"

  default = {
    production  = "prod"
    staging     = "staging"
    development = "dev"
  }
}

# Output data
output "elb_fqdn" {
  value = "${aws_route53_record.elb_dns.fqdn}"
}
