# Terraform: elb
Simple ELB creation, with A record in Route53. Supports SSL and non-SSL Load Balancers.

The default use of this module creates an HTTPS load balancer that communicates with the backends also using HTTPS.
A second (insecure) listener for port 80 is also created, but can be turned off by setting `port80` to `false`.

### Inputs

*   `account`: AWS account to create the ELB in.
*   `environment`: Environment this ELB lives in; determines ELB name, tags and optionally part of the dns record.
*   `service`: Service that this ELB sits in front of (e.g. `graphite-web`, `my-cool-http-api`, etc)
*   `lb_port`: The port which the ELB listens on. Defaults to `443`.
*   `lb_protocol`: The protocol (e.g. `http`, `https`, `tcp`, etc). Defaults to `https`.
*   `instance_port`: The port that traffic is forwarded to instances on. Defaults to `lb_port`.
*   `instance_protocol`: The instance protocol (e.g. `http`, `https`, `tcp`, etc). Defaults to `lb_protocol`.
*   `subnets` (list): The subnets (and thus availability zones) that this ELB should exist in
*   `security_groups` (list): Security groups to apply to the ELB
*   `instances` (list): List of instance ID's; puts these instances behind the ELB

#### Required Inputs
*   `r53_zone_id`: Zone ID for a zone in the account with the ELB to create a vanity DNS name.
*   `r53_profile`: The account name in your AWS credentials where the zone lives. Defaults to `account`.
*   `evaluate_target_health`: This lands on the DNS record. [Read more here.](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-complex-configs.html)

Recommend using a env.subdomain.twitch.a2z.com zone.
**The default zone only works with twitch-central-aws, so you must provide your own!**

#### Optional Inputs
*   `region`: Region to provision the ELB in, defaults to `us-west-2`
*   `ssl_arn`: If using SSL, the ARN of the ACM cert: `arn:aws:iam::<account number>:server-certificate/cert-name`
*   `regional_dns`: By default a DNS record without the region name is created. ie. us-west-2.
     Setting this to true prevents that and instead includes the region in the created DNS record.
     Set this to true when you create ELBs-per-region with the same `service` name.
*   `env_dns`: By default the dns record has no environment name in it. Set this to true to include the environment.
*   `port80`: Setting this to false changes the port 80 http listener to a port 65535 tcp listener.

### What's Generated

*   An ELB named `$service-$environment`
*   A DNS record for `$service.$region.$r53_zone_name` pointing to the ELB
*   OR: A DNS record for `$service.$r53_zone_name` pointing to the ELB
