# Required
variable "account" {}

variable "environment" {}
variable "service" {}

variable "lb_port" {
  default = 443
}

variable "lb_protocol" {
  default = "https"
}

variable "port80" {
  default     = "true"
  description = "By default this module makes https and http listeners. If you do not want the second http listener on port 80, set this to false and it will become a tcp listener on port 65535."
}

variable "evaluate_target_health" {}

# Defaults to lb_port
variable "instance_port" {
  default = ""
}

# Defaults to lb_protocol
variable "instance_protocol" {
  default = ""
}

# Defaults to no ssl.
variable "ssl_arn" {
  default = ""
}

variable "regional_dns" {
  default = "false"
}

variable "env_dns" {
  default = "false"
}

variable "subnets" {
  type = "list"
}

variable "security_groups" {
  type = "list"
}

variable "instances" {
  type = "list"
}

# Optional
variable "region" {
  default = "us-west-2"
}

# prod.systems.twitch.a2z.com is our default. Makes host names like:
# service-name.us-west-2.prod.systems.twitch.a2z.com
# Here's some other examples you may wish to use in the central accounts:
# - stage.systems.twitch.a2z.com Z28FIFQ3YEU8LW (twitch-central-dev)
# -   dev.systems.twitch.a2z.com ZJO286TVG0E2F  (twitch-central-dev)
# - stage.central.twitch.a2z.com Z3N884MC32MHR1 (twitch-central-dev)
# -   dev.central.twitch.a2z.com Z2P1TI4LX37TN8 (twitch-central-dev)
# -  prod.central.twitch.a2z.com Z167ZF1D2TOFR8 (twitch-central-aws)
variable "r53_zone_id" {
  default = "Z2SYORN9EDMU4L"
}

variable "r53_profile" {
  default = ""
}

# Output data
output "elb_fqdn" {
  value = "${aws_route53_record.elb_dns.fqdn}"
}

output "elb_name" {
  value = "${aws_elb.elb.name}"
}

output "elb_dns_name" {
  value = "${aws_elb.elb.dns_name}"
}

output "elb_zone_id" {
  value = "${aws_elb.elb.zone_id}"
}
