# eni-creation
Creates Elastic Network Interface resources

Required Variables:

- eni_name               - Value for the "Name:" tag to be populated with
- eni_count              - Number of ENIs to create
- vpc_security_group_ids - List of security group IDs to iterate through
- subnet_ids             - List of subnet IDs this module will iterate through

Optional Variables:
- providers              - Map of providers to override the default 'aws' provider.
- tags                   - Map of additional tags for the resources created

### Example usage:
```
# if you need a specific provider instance, set it up before calling
provider "aws" {
  alias   = "usw2"
  profile = "twitch-central-aws"
  region  = "us-west-2"
}

module "enis" {
  source                 = "git@git-aws.internal.justin.tv:terraform-modules/eni-creation"
  eni_name               = "dns-cache-central"
  eni_count              = 4
  instances              = "${module.instances.instance_ids}"
  vpc_security_group_ids = ["${module.variables.vpc_security_group_ids}"]
  subnet_ids             = ["${module.variables.subnet_ids}"]

  providers = {
    aws = "aws.usw2"
  }
}
```
