# Input arguments, required

variable "eni_name" {}

variable "subnet_ids" {
  type = "list"
}

variable "vpc_security_group_ids" {
  type = "list"
}

variable "eni_count" {}

output "ids" {
  value = ["${aws_network_interface.eni.*.id}"]
}

variable "tags" {
  type    = "map"
  default = {}
}

output "ips" {
  value = ["${aws_network_interface.eni.*.private_ips}"]
}

output "values" {
  value = "${zipmap(aws_network_interface.eni.*.id, aws_network_interface.eni.*.private_ips)}"
}
