resource "aws_vpc_endpoint" "endpoint" {
  vpc_id              = "${var.vpc_id}"
  service_name        = "${var.vpc_endpoint_service_name}"
  vpc_endpoint_type   = "Interface"
  private_dns_enabled = false
  security_group_ids  = ["${var.security_group}"]
  subnet_ids          = "${var.subnet_ids}"

  tags = {
    Name = "vpc endpoint created via Fulton CLI for ${var.service_name}"
  }
}

resource "aws_route53_zone" "route53_zone" {
  name = "${var.service_dns_entry}"

  vpc {
    vpc_id = "${var.vpc_id}"
  }
}

resource "aws_route53_record" "alias_a" {
  zone_id = "${aws_route53_zone.route53_zone.zone_id}"
  name    = "${var.service_dns_entry}"
  type    = "A"

  alias {
    name                   = "${aws_vpc_endpoint.endpoint.dns_entry.0.dns_name}"
    zone_id                = "${aws_vpc_endpoint.endpoint.dns_entry.0.hosted_zone_id}"
    evaluate_target_health = false
  }
}
