ELB HTTP Health Checks
---

Automatically configures a specified ELB with 3 useful health checks that monitor the following:
   * Number of healthy backend instances (that pass the ELB's internal backend health checker)
   * Rate of 5XX produced by backend instances
   * Latency of requests against the ELB

The consumer provides the thresholds for these three alerts, and infrastructure
(SNS + CloudWatch) is used to monitor these metrics and automatically fire
alerts to PagerDuty when the thresholds are crossed.

### Input Variables

#### Required

* `account` - AWS Account in which to create alerting infra; must be same account as ELB
* `pagerduty_cloudwatch_endpoint` - The HTTPS URL of the PagerDuty integration endpoint to page upon alert (e.g. `https://events.pagerduty.com/integration/b5a21b560d1846898494ea5dc923c2e8/enqueue`)
* `elb_name` - The name of the ELB to configure alerting for (e.g. `aws_elb.my_cool_elb.name`)
* `5xx_threshold` - The HTTP 5XX rate at which this ELB should fire an alert
* `latency_threshold` - The average latency at which this ELB should fire an alert

#### Optional
* `healthy_backends_threshold` - The minimum number of healthy hosts required to not alert; the default is 1, meaning the ELB alerts only when there are _no_ healthy backend instances
* `5xx_rate_threshold` - The HTTP 5XX rate at which this ELB should fire an alert; defaults to 10
* `latency_threshold` - The average latency, in milliseconds, at which this ELB should fire an alert; defaults to 5000
* `evaluation_periods` - The number of times a check must fail before alerting; defaults to 5
* `check_period` - The frequency at which the checks are run, in seconds; defaults to 60
* `region` - AWS region to create infrastructure in


### Created Resources

- A unique SNS Topic for the ELB
- Subscription of the PagerDuty endpoint to the SNS Topic
- 3 CloudWatch Metric Alarms which push notifications to the SNS Topic:
  - 5XX Rate
  - Latency
  - Healthy Backend Count
