# Creates a read_only_arn only role
provider "aws" {
  # Region doesn't matter for IAM, but is required for the provider.
  region = "us-west-2"
  profile = "${var.account}"
}

resource "aws_iam_role" "inventory_read_only" {
  name = "inventory-read-only"
  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": {
        "AWS": "arn:aws:iam::007917851548:role/master-inventory-read-only"
      },
      "Action": "sts:AssumeRole"
    }
  ]
}
EOF
}

# policy to allow access to support api
resource "aws_iam_policy" "cost_explorer" {
  name = "cost_explorer_full"
  description = "access to cost explorer data"
  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": "ce:*",
      "Resource": "*"
    }
  ]
}
EOF
}

# Attach permissions to iam_role
resource "aws_iam_role_policy_attachment" "inventory_read_only" {
  role = "${aws_iam_role.inventory_read_only.name}"
  policy_arn = "${var.read_only_arn}"
}

resource "aws_iam_role_policy_attachment" "inventory_read_only_support" {
  role = "${aws_iam_role.inventory_read_only.name}"
  policy_arn = "${var.support_access_arn}"
}

resource "aws_iam_role_policy_attachment" "cost_explorer" {
  role = "${aws_iam_role.inventory_read_only.name}"
  policy_arn = "${aws_iam_policy.cost_explorer.arn}"
}
