# Creates a Network-Administrator role

data "aws_region" "current" {
}

locals {
  # figure out if we have a default or overriden variable for var.create
  # if default, create only if region == us-west-2 (emulate legacy behaviour)
  # else use var.create
  create_count = var.create == "true" ? 1 : 0
  usw_count    = data.aws_region.current.name == "us-west-2" ? 1 : 0
  create       = var.create != "default" ? local.create_count : local.usw_count
}

data "aws_iam_policy_document" "network-admin-role-policy" {
  statement {
    actions = ["sts:AssumeRole"]

    principals {
      type        = "AWS"
      identifiers = ["arn:aws:iam::007917851548:role/network-admin-role"]
    }
  }
}

resource "aws_iam_role" "network_admin_role" {
  # We only want this role generated when us-west-2 is ran so that modules
  # using this such as account_template continue to work.
  count              = local.create
  name               = "network-admin-role"
  assume_role_policy = data.aws_iam_policy_document.network-admin-role-policy.json
  description        = "Created by terraform-modules/network-admin-role to make it easy for core systems to accept direct connect virtual interfaces"
}

# Attach permissions to assumed role
resource "aws_iam_role_policy_attachment" "network_admin_role" {
  # Same as the comment for the aws_iam_role resource above.
  count      = local.create
  role       = aws_iam_role.network_admin_role[count.index].name
  policy_arn = var.net_admin_arn
}
