# privatelink-alb

Provide PrivateLink Configuration into ALB.

Creates a privatelink that points to a "dns name" - PLs normally only support Instances or IPs.

To make it work, a lambda is created that re-resolves the "dns name" every 1 minute and updates the NLB targets.


Usage Example for TPS-enabled service:
```
module "privatelink" {
  source      = "git::git+ssh://git@git-aws.internal.justin.tv/terraform-modules/privatelink-alb.git?ref=dn2_one"
  account     = "twitch-central-dev"
  service     = "nagios"
  environment = "staging"
  dns_name    = "${module.elb_https.elb_dns_name}" // any dns name.
  vpc         = "vpc-a19ca9c5"                     // vpc in twitch-central-dev
  subnets     = ["${module.variables.subnet_ids}"] // list of subnets in vpc
}
```

If you're not using TPS, ensure the values for `acceptance_required` and `vpc_endpoint_service_allowed_principals` are appropriate for your VPC endpoint service.
Their defaults are designed to be used with TPS.
