variable "account" {
  type        = string
  description = "AWS account where the PrivateLink should be setup."
}

variable "region" {
  type        = string
  default     = "us-west-2"
  description = "AWS region where the PrivateLink should be setup."
}

variable "s3_bucket" {
  default     = ""
  type        = string
  description = "The name of the S3 bucket the configuration will be stored in. Automatically set to the value of $account."
}

variable "service" {
  type        = string
  description = "Application name for the PrivateLink setup."
}

variable "environment" {
  type        = string
  description = "Environment PrivateLink is for."
}

variable "dns_name" {
  type        = string
  description = "DNS name for the load balancer."
}

variable "vpc" {
  type        = string
  description = "VPC where the PrivateLink should be setup."
}

variable "lb_port" {
  default     = "443"
  type        = string
  description = "Port the ALB and NLB listen on."
}

variable "subnets" {
  type        = list(string)
  description = "List of subnets to use."
}

variable "vpc_endpoint_service_allowed_principals" {
  default     = [""]
  type        = list(string)
  description = "The ARNs that are whitelisted to access the VPC endpoint service. If you set acceptance_required to false, provide a list of principals."
}

variable "acceptance_required" {
  default     = true
  type        = string
  description = "If you are using a whitelist and do not require acceptence, set this to false. If using TPS, leave this at true."
}

output "vpc_endpoint_name" {
  value = "${aws_vpc_endpoint_service.vpc_endpoint_service.service_name}"
}

output "vpc_endpoint_id" {
  value = "${aws_vpc_endpoint_service.vpc_endpoint_service.id}"
}

output "nlb_tg_arn" {
  value = "${aws_lb_target_group.pl_target_group.arn}"
}

output "nlb_arn" {
  value = "${aws_lb.pl_nlb.arn}"
}
