# Input arguments, required

variable "account" {}
variable "subnet_ids" { type = "list" }
variable "vpc_security_group_ids" { type = "list" }
variable "environment" {}
variable "ami" {}
variable "owner" {}
variable "instance_profile" {}
variable "size" {}

# Prometheus specific args
variable "team" {}

# Input arguments, optional
variable "region" { default = "us-west-2" }
variable "r53_zone_id" { default = "ZRG00SM48517Z" }
variable "puppet" { default = "puppet" } # as opposed to puppet-ci
variable "root_block_device_size" { default = 32 }
variable "additional_facts" { 
  default = []
  type = "list"
}
variable "additional_iam_roles" { 
  default = []
  type = "list"
}
variable "count" { default = 1 }


# Internal variables, mostly maps to use to generate secondary variables
# based on the passed in arguments
variable "puppet_server" {
  type = "map"
  default = {
    puppet = "puppet.internal.justin.tv"
    puppet-ci = "puppet.prod.us-west2.justin.tv"
  }
}

# For use with creating FQDNs
variable "environment_shortname" {
  type = "map"
  default = {
    production = "prod"
    staging = "staging"
    development = "dev"
  }
}

variable "dns_region" {
  type = "map"
  default = {
    us-west-2 = "us-west2"
    us-east-1 = "us-east1"
  }
}

# For use with tagging semantics as laid out
# by the capacity planing team. Used as the Environment
# tag given to the EC2 instance
variable "environment_tagname" {
  type = "map"
  default = {
    production = "prod"
    staging = "stage"
    development = "dev"
  }
}

# Instance type is dynamically chosen based on
# the specified cluster size
variable "instance_type" { 
  type = "map"
  default = {
    small = "m4.large"
    medium = "m4.xlarge"
    large = "m4.2xlarge"
    xlarge = "m4.4xlarge"
  }
}

# Size of disks to provision, in GB
variable "disk_size" {
  type = "map"
  default = {
    small = "1000"
    medium = "2000"
    large = "4000"
    xlarge = "8000"
  }
}

variable "vpc_id" {
  type = "map"
  default = {
    development = "vpc-a19ca9c5"
    production = ""
  }
}


# Outputs
output "instance_ids" { value = ["${aws_instance.instances.*.id}"] }
output "fqdns" { value = ["${aws_route53_record.instances_dns.*.fqdn}"] }

