provider "aws" {
  alias = "${var.account}"
  region = "${var.region}"
  profile = "${var.account}"
}

# Basic IAM Role
resource "aws_iam_role" "iam_role" {
  provider = "aws.${var.account}"
  name = "${var.role}-${var.environment}"
  path = "/"
  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "ec2.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

# Instance profile for the instances
resource "aws_iam_instance_profile" "instance_profile" {
  provider = "aws.${var.account}"
  name = "${var.role}-${var.environment}"
  roles = ["${concat(list(aws_iam_role.iam_role.id), var.additional_iam_roles)}"]
  depends_on = ["aws_iam_role.iam_role"]
}
