Route53 Backup
---

Performs a daily backup of Route53 and stores it into S3.

This is the terraform deployment for route53backup.

## Set up

To add a new account, see example below.

TL;DR you're just adding the account and region of where to create the resources. Once you do this
terraform will spin everything you need, including the lambda contents and start backing up route53.

## Defaults to be aware of

The default functionality is that this lambda will be triggered once a day and will write a CSV and json file of each domain to a folder. 
The S3 bucket has a retention policy set to 365 days.
The lambda _does_ have logging enabled and writes those to cloud watch

## Running Terraform

This project was designed for terraform 0.11.14. You only need to make sure your .aws/credentials file has the account listed.

In your account folder you will need to first run:

```terraform init```

followed by:

```terraform plan```

Verify that we are *only* creating resources.

Once it looks good run:

```terraform apply```

After that you don't need to do anything else. Your records are being backed up.
If you want to verify, check the lambda and S3 bucket as it should have ran when uploaded.

## Example

```provider "aws" {
  alias   = "<account-name-here>" #This will look something like twitch-central-dev
  profile = "<account-name-here>" #This will look something like twitch-central-dev
  region  = "<region-here>" #This will look something like us-west-2
}

module "route53_backup" {
  source  = "/route53-backup/backup"
  region  = "<region-here>" #This will look something like us-west-2
  account = "<account-name-here>" #This will look something like twitch-central-dev

  providers = {
      aws = "aws.<account-name-here>" #This will look something like twitch-central-dev
  }
}

terraform {
  backend "s3" {
    bucket  = "<account-name-here>" #This will look something like twitch-central-dev
    key     = "tfstate/<environment>/route53-backup/terraform.tfstate"  #This will look something like Development or Production.. or if you have a place you are storing tfstate files to, add that here
    region  = "<region-here>" #This will look something like us-west-2
    profile = "<account-name-here>" #This will look something like twitch-central-dev
  }
}```