sandstorm-policy-attachment
===

Takes in an IAM Role and a managed Sandstorm role, and creates a policy granting access to assume the Sandstorm role to the given IAM role.

Sample
---

```
module "sandstorm-policy-attachment" {
    source          = "git::git+ssh://git@git-aws.internal.justin.tv/terraform-modules/sandstorm-policy-attachment.git"
    iam_role       = "${aws_iam_role.iam_role.id}"
    sandstorm_role = "${var.service}-${var.environment}"
    account        = "twitch-myteam-aws"
}
```

Inputs
---

`iam_role` - (required) The IAM Role to grant the assume role to
`sandstorm_role` - (required) The Sandstorm role (created through Dashboard) that should be allowed to be assumed.

Outputs
---

N/A
