provider "aws" {
  alias = "${var.account}"
  region = "${var.region}"
  profile = "${var.account}"
}

resource "aws_iam_role_policy" "sandstorm_role_access" {
  provider = "aws.${var.account}"
  name = "${var.iam_role}-sandstorm"
  role = "${var.iam_role}"
  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Action": "sts:AssumeRole",
            "Resource": "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/${var.sandstorm_role}",
            "Effect": "Allow"
        }
    ]
}
EOF
}
