taglib
======

taglib helps to reduce the copypasta in your terraform.

rather than copy/pasting the k/v series for `Name`, `Src`, `Environment` on each aws resource in tf, call this and set `tags = "${module.taglib.tags}"` in each resource.

type less.

as a bonus, it has outputs for asg tagging, because their tag structure is weird - that is under `${module.taglib.aws_default_tags}`.

there is also an eye towards something that can be used in cloud-init metadata as facter facts. that is less tested at this time.

"but what if I need to override the name for this one thing?!" I hear - terraform has a merge operator in interpolation - `merge(module.taglib.tags,map("Name","special")) works.`

"what if I want MOAR TAGS!" - there's a `tags` _input_ here that takes a map and merges that in for you. there's also a `facts` input.

the mandatory inputs are currently:
- `name` - maps to `Name` in tag outputs
- `owner` - maps to `twitch_team` fact, `Owner` in tag outputs
- `service` - maps to `Service` in tag outputs
- `srctag` - this tag should be used to help identify what source code repository is involved with the resources - maps to `Src` in tag outputs. usually a high-level repo name, then a relative path in that repo. example: `systems-terraform:development/dns-cache/per-region`

a full list of inputs includes descriptions in tf - see [inputs.tf](/inputs.tf)

the outputs are currently:
- `asg_default_tags` - an appropriate list of maps for ASG resource tagging. the output here is modified by `do_not_propogate_tags` so that a tag can be removed from consideration on the instance the ASG launches. that list defaults to `Name`.
- `ec2data_fact_stanza` - a chunk of text in cloud-formation YAML syntax that may be included as part of a launch config. contains facts for facter in the instance.
- `tags` - a map appropriate for tagging non-asg AWS resoures.

developing
----------

If you are developing against taglib, run the test! It lives in `./test.sh` and will run a scratch terraform apply. It then compares `terraform output` against `test.out` to tell you if it changed. If you're expecting new outputs, you will need to change that. If you're expecting different inputs, you should be editing `test.tfvars` to reflect that and the script should return PASS to you.
