variable "disable_consul" {
  default     = "true"
  description = "disable consul switch (disables consul by default)"
  type        = string
}

variable "do_not_propagate_tags" {
  default     = ["Name"]
  description = "list of tags to mark as non-propgating in an asg"
  type        = list(string)
}

variable "environment" {
  default     = "devel"
  description = "maps to AWS Environment tag, twitch_environment fact"
  type        = string
}

variable "facts" {
  default     = {}
  description = "additional Facter facts"
  type        = map
}

variable "name" {
  type        = string
  description = "maps to AWS Name tag"
}

variable "owner" {
  type        = string
  description = "maps to AWS Owner tag, twitch_team fact"
}

variable "role" {
  description = "role (frmr cluster) for twitch instances"
  type        = string
  default     = ""
}

variable "service" {
  type        = string
  description = "maps to AWS Service tag"
}

variable "srctag" {
  type        = string
  description = "maps to AWS Src tag"
}

variable "tags" {
  type        = map
  default     = {}
  description = "additional AWS Tags"
}
