# put all the logic to make tags here, ok?

# grab the aws region as a pop default here. if you're not _in_ aws, well...
data "aws_region" "current" {}

locals {
  # first, mangle the inputs slightly.
  # no really, this is the easiest way to check for characters in a string.
  owner = replace(var.owner, "@", "") != var.owner ? var.owner : "${var.owner}@twitch.tv"

  # if we _have_ a full email address, drop the domain for the fact, though.
  team  = replace(var.owner, "@.*$", "")

  # lowercase environment
  env = lower(var.environment)

  # forced AWS tags from inputs
  def_tags = {
    Name        = var.name
    Src         = var.srctag
    Environment = local.env
    Owner       = local.owner
    Service     = var.service
  }

  # now for the facter side. also templated below.
  def_facts = {
    clean              = "true"
    disable_consul     = var.disable_consul
    twitch_environment = local.env
    twitch_role        = var.role
    cluster            = var.role
    twitch_team        = local.team
    pop                = data.aws_region.current.name
  }

  # merge facts and tag blocks with any user parameters
  tags  = merge(var.tags,local.def_tags)
  facts = merge(var.facts,local.def_facts)

  # ASG tags are a...peculiar struct. see below.
  asg_default_tags = compact(data.template_file.asg_tag.*.rendered)

  # collect all the fact fragments
  ec2data_fact_stanza = join("",data.template_file.ec2data_fact_stanzas.*.rendered)
}

# wrap the ASG tag structure around our tags block
# kv is a partial map with values pulled off the tags map
# p uses a conditional to reset tag propogation if item should be blocked - see var.do_not_propogate_tags
data "template_file" "asg_tag" {
  template = "{ $${kv} propagate_at_launch = $${p} }"

  vars = {
    kv = "key = \"${element(keys(local.tags),count.index)}\", value = \"${lookup(local.tags,element(keys(local.tags),count.index))}\","
    p  = contains(var.do_not_propagate_tags,element(keys(local.tags),count.index)) ? "false" : "true"
  }

  count = length(keys(local.tags))
}

# wrap the def_facts map into some ec2 setup data
# one \n is double-escaped for the printf, the other is to actually make new lines
data "template_file" "ec2data_fact_stanzas" {
  template = "$${f}"

  vars = {
    # if a requested fact doesn't exist, noop the _line_. despair.
    f = lookup(local.facts,element(keys(local.facts),count.index)) == "" ? "" : "  - printf \"${element(keys(local.facts),count.index)}=%s\\n\" \"${lookup(local.facts,element(keys(local.facts),count.index))}\" > \"/etc/facter/facts.d/${element(keys(local.facts),count.index)}.txt\"\n"
  }

  count = length(keys(local.facts))
}
