#!/usr/bin/env bash

## a simple test - generate outputs and compare to test.out

# desired output state
COMPARE_OUTPUT=test.out

## setup
# configure AWS region through envvars
export AWS_DEFAULT_REGION=us-east-1
# use random state and output files for test
testout=$(mktemp /tmp/tftest.out.XXXXXX)
teststate=$(mktemp /tmp/tftest.state.XXXXXX)

## exec
# initialize providers as/if needed
terraform init
# generate outputs from current codebase
terraform apply -state="${teststate}" -var-file=test.tfvars
terraform output -state="${teststate}" > "${testout}"
# diff it but just tell me if it changed
diff "${testout}" "${COMPARE_OUTPUT}" > /dev/null 1>&2 ; rc="${?}"

## cleanup
rm "${teststate}"
rm "${testout}"

## return the diff status
[[ "${rc}" -eq 0 ]] && echo "PASS"
[[ "${rc}" -ne 0 ]] && echo "FAIL"
exit "${rc}"
