Template Terraform Module
===

Inputs
---

Here you should put your inputs. 

Required:
```
account - The AWS account to create resources in. Will use a profile with the same name as a provider in this module.
environment - The environment to provision in, e.g. production, development, etc
...
...
```

Optional:
```
region - The region to provision resources in (default: us-west-2)
count - The number of foobars to provision (default: 1)
...
...
```

Outputs
---

```
foobar_ids - IDs of the foobars provisioned (type: list)
foorbar_iam_policy_id - ID of IAM policy attached to foobar role (type: string)
...
...
```

Starting from this Template
---

1. Create a GHE repo for your module in the `terraform-modules` organization, no README or anything
2. `git clone git@git-aws.internal.justin.tv:terraform-modules/template-module`
3. Delete everything in this section of the README and onward
4. `git remote rm origin`
5. `git remote add origin git@git-aws.internal.justin.tv:terraform-modules/your-module`
6. `git push origin master`

Tagging and Versioning
---

Tag your modules with versions using `git tag vX.Y.Z` and `git push --tags`.

*Adhering closely to a versioning guideline is super important to help people use shared modules 
successfully!*

Use the following versioning rules:

- Version with tags of the form `vX.Y.Z`, where `X` is the major version, `Y` is the minor version, and `Z` is the patch version. Start at `v0.0.0`.
- Patch level upgrades: will not change any internal resources. Example: changing structure or refactoring, adding or changing outputs
- Minor version upgrades: may change internal resources (`~`), but does not destroy or re-create (`-/+`) anything. Example: Changing an internal IAM policy
- Major version upgrades: may destroy/recreate internal resources.  Example: Changing default subnet ID's, making instances get recreated.


Things to NOT do in this Module
---

Do _not_ source another module.  Terraform should be as flat as possible to reduce confusion and avoid unintentional bubbling
up of breaking changes.


Multiple AWS Accounts
---

When taking certain actions, you may need to use a combination of AWS accounts. The most notable example is needing
to create instances in a local account and DNS records in `twitch-aws`.  To facilitate this, this template comes out
of the box requiring an `account` variable to be passed in. Terraform "providers" are created for the passed in account
as well as `twitch-aws`.  By default, Terraform will pick an account to provision the resources in based on your `[default]`
profile in `~/.aws/credentials`, which may or may not be the proper account. To be more explicit about resource placement,
In each AWS resource defined, add `provider = "aws.${var.account}"` to place the resource in the passed in resource, and
`provider = "aws.twitch-aws"` to place the resource in `twitch-aws`.  Check out the source of this template and/or Terraform
provider docs for more information.  Forgetting to place provider declarations can result in resources provisioned in the wrong account.

For the most pleasant Terraform experience, _remove all AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY environment variables from your session and use the `~/.aws/credentials` file instead._


