# tf-ssm//global/iam Terraform Module
A terraform module to create IAM users, roles, and policies to use SSM.

## Module Input Variables
* aws_profile - AWS profile name from ~/.aws/config
* enable_baremetal - Create resources needed to support bare metal.  Boolean.
* ssmservice_policy - AWS IAM trust policy for SSM usage
* ssmmanagedinstance_policy - AWS IAM trust policy for bare metal support
* activation_policy - AWS IAM User Policy for activation user
* pgpkey - AWS IAM User Policy for activation user
* s3outputbucketname - Name of the S3 bucket to store command output (must be unique)

## Module Outputs
* SSMServiceRole.arn
* SSMServiceRole.create_date
* SSMServiceRole.unique_id
* SSMServiceRole.name
* SSMServiceRole.description
* SSMManagedInstance.arn
* SSMManagedInstance.create_date
* SSMManagedInstance.unique_id
* SSMManagedInstance.name
* SSMManagedInstance.description
* SSMManagedInstance.id
* SSMManagedInstance.name
* SSMActivation.name
* SSMActivation.unique_id
* SSMActivation.arn
* SSMActivation.id
* SSMActivation.user
* SSMActivation.key_fingerprint
* SSMActivation.encrypted_secret
* SSMActivation.status

## Usage
```js
module "tf_ssm_iam" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/vidops/tf-ssm.git//global/iam?ref=1.0.0"
  aws_profile = "${var.aws_profile}"
}
```
