# IAM role that allows bare metal to talk to SSM service
resource "aws_iam_role" "SSMServiceRole" {
  name = "SSMServiceRole"
  description = "Role that allows bare metal to talk to SSM service (TF Managed)"
  assume_role_policy = "${var.ssmservice_policy}"
}

# IAM role to attach to ec2 managed instances
resource "aws_iam_role" "SSMManagedInstance" {
  name = "SSMManagedInstance"
  description = "Allows EC2 instances to call AWS services on your behalf (TF Managed)"
  assume_role_policy = "${var.ssmmanagedinstance_policy}"
}

resource "aws_iam_role_policy_attachment" "SSMManagedInstancePolicyAttachment" {
  role = "${aws_iam_role.SSMServiceRole.name}"
  policy_arn = "arn:aws:iam::aws:policy/service-role/AmazonEC2RoleforSSM"
}

# IAM role that allows management of SSM activations and managed instances
resource "aws_iam_role" "SSMManagement" {
  name = "SSMManagement"
  description = "Allows management of SSM activations and managed instances (TF Managed)"
  assume_role_policy = "${var.ssmmanagement_policy}"
}

resource "aws_iam_role_policy_attachment" "SSMManagement" {
  role = "${aws_iam_role.SSMManagement.name}"
  policy_arn = "${aws_iam_policy.SSMManagement.arn}"
}

# IAM user to create SSM activations
resource "aws_iam_user" "SSMActivationUser" {
  name = "SSMActivationUser"
}

resource "aws_iam_access_key" "SSMActivationUserAccessKey" {
  user = "${aws_iam_user.SSMActivationUser.name}"
  pgp_key = "${var.pgpkey}"
}

# IAM policy to create SSM activations
resource "aws_iam_policy" "SSMManagement" {
  name = "SSMManagement"
  description = "Allows management of activations and managed instances (TF Managed)"
  policy = "${var.activation_policy}"
}

resource "aws_iam_user_policy_attachment" "SSMManagement" {
  user = "${aws_iam_user.SSMActivationUser.name}"
  policy_arn = "${aws_iam_policy.SSMManagement.arn}"
}
