variable "aws_profile" {
  description = "AWS profile for provider"
  default = ""
}

variable "aws_region" {
  description = "AWS region for provider"
  default = "us-west-2"
}

variable "pgpkey" {
  description = "PGP key to encrypt credentials for IAM user"
}

variable "ssmservice_policy" {
  description = "AWS IAM policy to allow bare metal to talk to ssm service"
  default = <<EOP
{
  "Version": "2012-10-17",
  "Statement": {
    "Effect": "Allow",
    "Principal": {"Service": "ssm.amazonaws.com"},
    "Action": "sts:AssumeRole"
  }
}
EOP
}

variable "ssmmanagedinstance_policy" {
  description = "Allows EC2 instances to call AWS services on your behalf."
  default = <<EOP
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": {
        "Service": "ec2.amazonaws.com"
      },
      "Action": "sts:AssumeRole"
    }
  ]
}
EOP
}

variable "ssmmanagement_policy" {
  description = "Allows management of SSM activations and managed instances."
  default = <<EOP
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": {
        "AWS": "arn:aws:iam::673385534282:role/provisioner-production-rw"
      },
      "Action": "sts:AssumeRole"
    }
  ]
}
EOP
}

variable "activation_policy" {
  description = "AWS IAM policy for the activation user"
  default = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "ssm:CreateActivation",
        "iam:PassRole",
        "ssm:AddTagsToResource",
        "ssm:DescribeActivations",
        "ssm:DeregisterManagedInstance",
        "ssm:DescribeInstanceInformation",
        "ssm:DeleteActivation"
      ],
      "Resource": "*"
    }
  ]
}
EOF
}
