# tf-ssm//global/s3 Terraform Module
A terraform module to create S3 bucket to store SSM Document output

## Module Input Variables
* aws_profile - AWS profile name from ~/.aws/config
* s3outputbucketname - Name of the S3 bucket to store command output (must be unique)

## Module Outputs
* SSMS3Output.id
* SSMS3Output.arn
* SSMS3Output.bucket_domain_name
* SSMS3Output.hosted_zone_id
* SSMS3Output.region

## Usage
```js
module "tf_ssm_s3" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/vidops/tf-ssm.git//global/s3?ref=1.0.0"
  aws_profile = "${var.aws_profile}"
  s3outputbucketname = "my_output_bucket"
}
```
