// Default bucket to store ssm outputs
resource "aws_s3_bucket" "SSMS3Output" {
  bucket = "${var.s3outputbucketname}"
}

// S3 bucket to store software inventory
resource "aws_s3_bucket" "resource_sync_s3_bucket" {
  bucket = "${var.s3outputbucketname}-inventory"
}

resource "aws_s3_bucket_policy" "resource_sync_s3_policy" {
  bucket = "${aws_s3_bucket.resource_sync_s3_bucket.bucket}"

  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Sid": "SSMBucketPermissionsCheck",
            "Effect": "Allow",
            "Principal": {
                "Service": "ssm.amazonaws.com"
            },
            "Action": "s3:GetBucketAcl",
            "Resource": "arn:aws:s3:::${var.s3outputbucketname}-inventory"
        },
        {
            "Sid": " SSMBucketDelivery",
            "Effect": "Allow",
            "Principal": {
                "Service": "ssm.amazonaws.com"
            },
            "Action": "s3:PutObject",
            "Resource": "arn:aws:s3:::${var.s3outputbucketname}-inventory/*",
            "Condition": {
                "StringEquals": {
                    "s3:x-amz-acl": "bucket-owner-full-control"
                }
            }
        }
    ]
}
EOF
}

resource "aws_ssm_resource_data_sync" "inventory" {
  name = "${aws_s3_bucket.resource_sync_s3_bucket.bucket}"

  s3_destination = {
    bucket_name = "${aws_s3_bucket.resource_sync_s3_bucket.bucket}"
    region      = "${aws_s3_bucket.resource_sync_s3_bucket.region}"
  }

  depends_on = ["aws_s3_bucket_policy.resource_sync_s3_policy"]
}
