// Enable software inventory out of the box
resource "aws_ssm_association" "AWS-GatherSoftwareInventory" {
  name = "AWS-GatherSoftwareInventory"

  schedule_expression = "${var.docassoccron}"

  targets {
    key    = "InstanceIds"
    values = ["*"]
  }

  output_location {
    s3_bucket_name = "${var.s3outputbucket}"
  }
}

// Keep SSM Agent up to date
resource "aws_ssm_association" "AWS-UpdateSSMAgent" {
  name = "AWS-UpdateSSMAgent"

  targets {
    key    = "tag:${var.catchalltag}"
    values = ["${var.catchallvalue}"]
  }

  schedule_expression = "${var.docassoccron}"

  output_location {
    s3_bucket_name = "${var.s3outputbucket}"
  }
}
