###
# Input variables
###
variable "environment" {}


###
# Values based on environment
###
variable "vpc_security_group_ids" {
  type = "map"
  default = {
    production = "sg-27d18d42" 
    staging = "" # TODO
    development = "" # TODO
  }
}

variable "subnet_ids" { 
  type = "map"
  default = {
    production = "subnet-faa4239f,subnet-88a207ff,subnet-9c4ab1c5"
    staging = "" # TODO
    development = "" # TODO
  }
}

variable "r53_zone_id" { 
  type = "map"
  default = {
    production = "ZRG00SM48517Z" 
  }
}

###
# Outputs generated based on input environment
###
output "subnet_ids" {
  value = "${split(",", lookup(var.subnet_ids, var.environment))}"
}

output "r53_zone_id" {
  value = "${lookup(var.r53_zone_id, var.environment)}"
}

output "vpc_security_group_ids" {
  value = ["${split(",", lookup(var.vpc_security_group_ids, var.environment))}"]
}
