###
# Input variables
###
variable "region" {
  type    = "string"
  default = "us-west-2"
}

###
# Values based on environment
###
variable "vpc_security_group_ids" {
  type = "map"

  default = {
    ap-south-1     = ""
    eu-west-1      = "sg-7be2df03"
    ap-northeast-2 = ""
    ap-northeast-1 = ""
    sa-east-1      = ""
    ap-southeast-1 = "sg-c3a1d5a5"
    ap-southeast-2 = ""
    eu-central-1   = ""
    us-east-1      = "sg-8c54a0f1"
    us-east-2      = "sg-0c4938b161b962770"
    us-west-1      = ""
    us-west-2      = "sg-1825527e"
  }
}

# Private subnets
variable "subnet_ids" {
  type = "map"

  default = {
    ap-south-1     = ""
    eu-west-1      = "subnet-6dac1a36,subnet-219af046,subnet-4891ec01"
    ap-northeast-2 = ""
    ap-northeast-1 = ""
    sa-east-1      = ""
    ap-southeast-1 = "subnet-4570c722,subnet-e574d1ac,subnet-0071c667"
    ap-southeast-2 = ""
    eu-central-1   = ""
    us-east-1      = "subnet-34ec316f,subnet-a9b26b84,subnet-5522ab1c,subnet-eac80bd6"
    us-east-2      = "subnet-03b76e4ae7be0d284,subnet-00a54c4ca4feee45c,subnet-0fcba3bbd1d26281d"
    us-west-1      = ""
    us-west-2      = "subnet-1a87f07e,subnet-0eb83678,subnet-828650da"
  }
}

# Public subnets
variable "public_subnet_ids" {
  type = "map"

  default = {
    ap-south-1     = ""
    eu-west-1      = "subnet-b385efd4,subnet-cca91f97,subnet-e994e9a0"
    ap-northeast-2 = ""
    ap-northeast-1 = ""
    sa-east-1      = ""
    ap-southeast-1 = "subnet-4670c721,subnet-9872c5ff,subnet-2673d66f"
    ap-southeast-2 = ""
    eu-central-1   = ""
    us-east-1      = "subnet-aab26b87,subnet-2bec3170,subnet-5222ab1b,subnet-ebc80bd7"
    us-east-2      = "subnet-02a7ecedc92ab8950,subnet-0f4ece6779e550c9f,subnet-0ceb06f80779b6a6e"
    us-west-1      = ""
    us-west-2      = "subnet-e487f080,subnet-0cb8367a,subnet-818650d9"
  }
}

###
# Outputs generated based on input environment
###
output "subnet_ids" {
  value = "${split(",", lookup(var.subnet_ids, var.region))}"
}

output "public_subnet_ids" {
  value = "${split(",", lookup(var.public_subnet_ids, var.region))}"
}

# prod.systems.twitch.a2z.com is our default. Makes host names like:
# cluster-name-instanceid.us-west-2.prod.systems.twitch.a2z.com
output "r53_zone_id" {
  value = "Z2SYORN9EDMU4L"
}

output "vpc_security_group_ids" {
  value = ["${split(",", lookup(var.vpc_security_group_ids, var.region))}"]
}

output "region" {
  value = "${var.region}"
}
