###
# Input variables
###
variable "region" {
  type    = "string"
  default = "us-west-2"
}

###
# Values based on environment
###
variable "vpc_security_group_ids" {
  type = "map"

  default = {
    ap-south-1     = ""
    eu-west-1      = ""
    ap-northeast-2 = ""
    ap-northeast-1 = ""
    sa-east-1      = ""
    ap-southeast-1 = ""
    ap-southeast-2 = ""
    eu-central-1   = ""
    us-east-1      = "sg-244dfb59"
    us-east-2      = ""
    us-west-1      = ""
    us-west-2      = "sg-e55f4f83"
  }
}

# Private subnet ids, used in most apps
variable "subnet_ids" {
  type = "map"

  default = {
    ap-south-1     = ""
    eu-west-1      = ""
    ap-northeast-2 = ""
    ap-northeast-1 = ""
    sa-east-1      = ""
    ap-southeast-1 = ""
    ap-southeast-2 = ""
    eu-central-1   = ""
    us-east-1      = "subnet-917caaad,subnet-dee68197,subnet-524ce409,subnet-b3f6419e"
    us-east-2      = ""
    us-west-1      = ""
    us-west-2      = "subnet-071c4763,subnet-42e99934,subnet-3e41f266"
  }
}

# Public subnet ID, used rarely
variable "public_subnet_ids" {
  type = "map"

  default = {
    ap-south-1     = ""
    eu-west-1      = ""
    ap-northeast-2 = ""
    ap-northeast-1 = ""
    sa-east-1      = ""
    ap-southeast-1 = ""
    ap-southeast-2 = ""
    eu-central-1   = ""
    us-east-1      = "subnet-927caaae,subnet-d5e6819c,subnet-514ce40a,subnet-8df641a0"
    us-east-2      = ""
    us-west-1      = ""
    us-west-2      = "subnet-3f41f267,subnet-47e99931,subnet-041c4760"
  }
}

variable "r53_zone_id" {
  type = "map"

  default = {
    staging     = "Z3N884MC32MHR1" # stage.systems.twitch.a2z.com
    stage       = "Z3N884MC32MHR1" # stage.systems.twitch.a2z.com
    dev         = "Z3O3L8XQEPHUU"  # dev.systems.twitch.a2z.com
    development = "Z3O3L8XQEPHUU"  # dev.systems.twitch.a2z.com
  }
}

variable "environment" {
  type    = "string"
  default = "development"
}

###
# Outputs generated based on input environment
###
output "subnet_ids" {
  value = "${split(",", lookup(var.subnet_ids, var.region))}"
}

output "public_subnet_ids" {
  value = "${split(",", lookup(var.public_subnet_ids, var.region))}"
}

output "r53_zone_id" {
  value = "${lookup(var.r53_zone_id, var.environment)}"
}

output "vpc_security_group_ids" {
  value = ["${split(",", lookup(var.vpc_security_group_ids, var.region))}"]
}

output "region" {
  value = "${var.region}"
}
