twitch-central-monitoring AWS Account: Terraform Defaults
===

Account ID: 151081709688

This repo contains a set of default values to export that define key identifiers
of the Systems Infrastructure's Monitoring AWS account.
For each environment, there should be defined:

-   VPC ID
-   Subnet IDs
-   R53 ID


How to use this Terraform code
===

In the `systems/systems-terraform` repo, add this to your project:

```
module "us_west_2_prod_defaults" {
  source      = "git::git+ssh://git@git-aws.internal.justin.tv/terraform-modules/twitch-central-monitoring-defaults?ref=v0.0.1"
  region      = "us-west-2"
  environment = "production"
}
```

To get the `central-monitor.xarth.tv` zone ID for a human ELB (ie. nagios interface), do something like this:
```
module "elb_zone" {
  source      = "git::git+ssh://git@git-aws.internal.justin.tv/terraform-modules/twitch-central-monitoring-defaults?ref=v0.0.1"
  environment = "elb"
}
```
Then reference the zone ID as `${module.elb_zone.r53_zone_id}`

To get the `central-monitoring.twitch.a2z.com` zone ID for a s2s (ie. nrdc->nagios interface), do something like this:
```
module "s2s_zone" {
  source      = "git::git+ssh://git@git-aws.internal.justin.tv/terraform-modules/twitch-central-monitoring-defaults?ref=v0.0.1"
  environment = "s2s"
}
```
Then reference the zone ID as `${module.s2s_zone.r53_zone_id}`
