###
# Input variables
###
variable "region" {
  default = "us-west-2"
}

###
# Environment decides which zone to use.
###
variable "environment" {
  default = "production"
}

###
# Values based on region
###
variable "vpc_security_group_ids" {
  type = "map"

  default = {
    us-west-2      = "sg-0d51739c58ab6720c" # twitch_subnets
    ap-south-1     = ""
    eu-west-1      = ""
    ap-northeast-2 = ""
    ap-northeast-1 = ""
    sa-east-1      = ""
    ap-southeast-1 = ""
    ap-southeast-2 = ""
    eu-central-1   = ""
    us-east-1      = ""
    us-east-2      = ""
    us-west-1      = ""
  }
}

# Private subnets
variable "subnet_ids" {
  type = "map"

  default = {
    us-west-2      = "subnet-058819fb7f0c622b4,subnet-06d3d44ff1338decd,subnet-05ae9b0d2ba555b5b"
    ap-south-1     = ""
    eu-west-1      = ""
    ap-northeast-2 = ""
    ap-northeast-1 = ""
    sa-east-1      = ""
    ap-southeast-1 = ""
    ap-southeast-2 = ""
    eu-central-1   = ""
    us-east-1      = ""
    us-east-2      = ""
    us-west-1      = ""
  }
}

# Public subnets
variable "public_subnet_ids" {
  type = "map"

  default = {
    us-west-2      = "subnet-05b9b2f5671f6a00d,subnet-08e3b22495cf59aec,subnet-057872af2b376ccc1"
    ap-south-1     = ""
    eu-west-1      = ""
    ap-northeast-2 = ""
    ap-northeast-1 = ""
    sa-east-1      = ""
    ap-southeast-1 = ""
    ap-southeast-2 = ""
    eu-central-1   = ""
    us-east-1      = ""
    us-east-2      = ""
    us-west-1      = ""
  }
}

# prod.central-monitoring.twitch.a2z.com is our default. Makes host names like:
# cluster-name-instanceid.us-west-2.prod.central-monitoring.twitch.a2z.com
variable "r53_zones" {
  type = "map"

  default = {
    prod        = "Z3JNIP2JC6430V" # prod.central-monitoring.twitch.a2z.com
    production  = "Z3JNIP2JC6430V" # prod.central-monitoring.twitch.a2z.com
    dev         = "Z1ZBTUYF7RAP13" # dev.central-monitoring.twitch.a2z.com
    stage       = "Z1ZBTUYF7RAP13" # dev.central-monitoring.twitch.a2z.com
    development = "Z1ZBTUYF7RAP13" # dev.central-monitoring.twitch.a2z.com
    staging     = "Z1ZBTUYF7RAP13" # dev.central-monitoring.twitch.a2z.com
    elb         = "Z1WAIGUSAJU78L" # central-monitor.xarth.tv
    s2s         = "ZK6MMSFAW3T0U"  # central-monitoring.twitch.a2z.com (useful for instance s2s cnames)
  }
}

###
# Outputs generated based on input environment
###
output "subnet_ids" {
  value = "${split(",", lookup(var.subnet_ids, var.region))}"
}

output "public_subnet_ids" {
  value = "${split(",", lookup(var.public_subnet_ids, var.region))}"
}

output "r53_zone_id" {
  value = "${lookup(var.r53_zones, var.environment)}"
}

output "vpc_security_group_ids" {
  value = ["${split(",", lookup(var.vpc_security_group_ids, var.region))}"]
}

output "region" {
  value = "${var.region}"
}
