# Twitch Inventory

Module to add the twitch inventory role to your account for central polling. It creates a policy for accessing Cost Explorer data, and uses the two built in policies for AWS Support and ReadOnly

Required variables
variable "account" {} The account name should have a corresponding profile in your ~/.aws/credentials file.

## Requirements
This module has been tested with Terraform v11.

If you receive an error concerning `max_session_duration`, you likely need to upgrade your Terraform version.

## Example Usage
Below is an example of how you can incorporate this module into your terraform configuration:

```
module "twitch-inventory" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/terraform-modules/twitch-inventory.git"
  account = "MY_AWS_ACCOUNT_PROFILE"
}
```
