###
# Input variables
###
variable "region" {
    type = "string"
    default = "us-west-2"
}

###
# Values based on environment
###
variable "vpc_security_group_ids" {
  type = "map"
  default = {
    us-west-2 = "sg-e145459c"
  }
}

variable "subnet_ids" {
  type = "map"
  default = {
    us-west-2 = "subnet-a63373c0,subnet-28d6b760,subnet-7f6e6f24"
  }
}

variable "r53_zone_id" {
  type = "map"
  default = {
    us-west-2 = "ZRG00SM48517Z"
    us-east-1 = "Z177PQ2GE292U3"
    us-east-2 = "Z2NT5X6CYYEP8Y"
    eu-west-1 = "Z1RE36DARE2RLE"
    ap-southeast-1 = "Z3D71RF114NJ6V"
  }
}

###
# Outputs generated based on input environment
###
output "subnet_ids" {
  value = "${split(",", lookup(var.subnet_ids, var.region))}"
}

output "r53_zone_id" {
  value = "${lookup(var.r53_zone_id, var.region)}"
}

output "vpc_security_group_ids" {
  value = ["${split(",", lookup(var.vpc_security_group_ids, var.region))}"]
}

output "region" {
    value = "${var.region}"
}
