# Video Organization Principal

This repo contains two terraform modules to enable non-specific assume-role
access within the Twitch Video Organization _from_ "source" IAM-Roles that
opt-in _to_ "destination" IAM-Roles that opt-in.

* A **Source IAM-Role** exposes access to other roles in Video.
* A **Destination IAM-Role** is a role that we want to let other things in
  Video access.

The readme below describes how to use this for your own IAM-Roles. The
"example" directory shows a demo usage that you can run against your own pair
of accounts.

## Source IAM-Role usage

Opt-in your source IAM-Role to allow assume-roles to any destination role, if
the destination allows, with the policy in the
`video-organization-principal//source` module.

```terraform
// (1 of 1) pass your source iam-role's name to an instantiation of the source-policy module
module "video_organization_principal_source" {
  source        = "git::git+ssh://git@git-aws.internal.justin.tv/terraform-modules/video-organization-principal.git//source"
  iam_role_name = aws_iam_role.my_source_iam_role.name
}
```

## Destination IAM-Role usage

Opt-in your destination IAM-Role to allow it to be assumed by any entity in the
_Twitch Video Organization_ with the trust-policy (terraform
`assume_role_policy`) in the `video-organization-principal//destination` module.

```terraform
// (1 of 2) instantiate the video-org principal destination-policy module
module "video_org_principal_destination" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/terraform-modules/video-organization-principal.git//destination"
}

// (2 of 2) include the destination-policy in the trust-policy on your destination iam-role
resource "aws_iam_role" "my_destination_iam_role" {
  name = "my_destination_iam_role"
  assume_role_policy = module.video_org_principal_destination.policy.json
}
```

# What is organizational access?

AWS supports constraining access based on _Organization ID_, _Root ID_, and
_Organizational Units_, which are groupings of AWS accounts. This was
introduced recently and is discussed in [Use IAM to share your AWS resources
with groups of AWS accounts in AWS Organizations](https://aws.amazon.com/blogs/security/iam-share-aws-resources-groups-aws-accounts-aws-organizations/).
