module "common" {
  source = "../common"
}

// Allow sts:AssumeRole from any principal in the organization to this
// IAM-Role.
data "aws_iam_policy_document" "organization_principal_policy_statement" {
  statement {
    effect = "Allow"
    principals {
      identifiers = ["*"]
      type        = "AWS"
    }
    actions = ["sts:AssumeRole"]
    condition {
      test     = "StringEquals"
      variable = "aws:PrincipalOrgID"
      values   = [module.common.twitch_video_organization_id]
    }
  }
}

output "policy" {
  value = data.aws_iam_policy_document.organization_principal_policy_statement
}
