# Example

This example directory provides an example use of the
`video-organization-principal//source` and
`video-organization-principal//destination` terraform modules together. The
`example/main.tf` file creates two IAM-Roles using two separate profiles
(potentially for distinct AWS accounts) in a shared-credentials file.

* ### Source IAM-Role
    * The source IAM-Role can be assumed by any entity in its own account.
    * The source IAM-Role can **perform assume-roles to any destination role,
      if the destination allows, because it uses
      `video-organization-principal//source`**.

* ### Destination IAM-Role
    * The destination IAM-Role can **be assumed by any entity in the _Twitch
      Video Organization_ because it uses
      `video-organization-principal//destination`**.
    * The destination IAM-Role cannot do anything.

The purpose of the example is to demonstrate that while the _source IAM-Role
isn't specific about what roles it can access,_ and the _destination IAM-Role
isn't specific about what roles can access it_ doing `AssumeRole` is still
possible.

## Run the example

You'll need terraform and golang.

### 1. Create a shared credentials file

Your `./aws_creds` file should look like this, with the values filled out for
the two profiles. You can name the profiles any way you like, just remember
which is the _source_ and which is the _destination_. For this example, let's
say we'll assume-role form profile `foo` to profile `bar`.

```
[foo]
aws_access_key_id=
aws_secret_access_key=
aws_session_token=

[bar]
aws_access_key_id=
aws_secret_access_key=
aws_session_token=
```

### 2. Create the example roles in your account

Plan the terraform in this `example/` directory. Specify the `source_profile`
and the `dest_profile` variables on the commandline.

```sh-session
$ terraform plan -out example.plan -var source_profile=foo -var dest_profile=bar
Refreshing Terraform state in-memory prior to plan...

...
```

Read the plan output to see what will happen. It creates two IAM-Roles as
described above. When you're satisfied, apply the plan.

```sh-session
$ terraform apply example.plan
aws_iam_role.dest_role: Creating...

...
```

At this point, it would be good to read the output from `terraform show`.

* Note that the source IAM-Role isn't specific about what roles it can access,
  and the destination IAM-Role isn't specific about what roles can access it.
* Note down the ARNs of the source and destination IAM-Roles.

### 3. Run the assume-role example

Run the example go-code. It takes three arguments.

* `-source-prof` Name of the profile in the shared-credential file to start
  with.
* `-source-role` ARN of the IAM-Role to assume-role away from.
* `-dest-role string` ARN of the IAM-Role to assume-role into.

```sh-session
$ go run main.go -source-prof foo -source-role arn:aws:iam::FOOACCTNUMBER:role/VIDTOOL_source_role -dest-role arn:aws:iam::BARACCTNUMBER:role/VIDTOOL_dest_role
{
  Account: "FOOACCTNUMBER",
  Arn: "arn:aws:sts::FOOACCTNUMBER:assumed-role/Admin/user-Isengard",
  UserId: "AROA4WTMOXOFAKE6FD6WM:user-Isengard"
} <nil>
{
  Account: "FOOACCTNUMBER",
  Arn: "arn:aws:sts::FOOACCTNUMBER:assumed-role/VIDTOOL_source_role/158516FAKE848837000",
  UserId: "AROA4WTMOXFAKEVQIOWCI:158516FAKE848837000"
} <nil>
{
  Account: "BARACCTNUMBER",
  Arn: "arn:aws:sts::BARACCTNUMBER:assumed-role/VIDTOOL_dest_role/1585166802848837000",
  UserId: "AROAXBGFAKEUFRXWE2NXQ:158516680297FAKE000"
} <nil>

```

The example prints out three caller-identities.

1. Caller-identity taken on when using the source profile credentials from the
   shared-credentials file
1. Assume-role caller-identity of the source IAM-Role
1. Assume-role caller-identity of the destination IAM-Role

If there's any problem with the organizational principal, then the third output
will show an error instead.
