package main

import (
	"flag"
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/credentials/stscreds"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/sts"
)

const (
	sharedCredsFile = "./aws_creds"
)

func main() {
	sourceProfile := flag.String("source-prof", "", "Name of the profile in the shared-credential file to start with.")
	sourceRoleARN := flag.String("source-role", "", "ARN of the IAM-Role to assume-role away from.")
	destRoleARN := flag.String("dest-role", "", "ARN of the IAM-Role to assume-role into.")
	flag.Parse()

	sess := session.Must(session.NewSession(aws.NewConfig().WithCredentials(credentials.NewSharedCredentials(sharedCredsFile, *sourceProfile))))
	fmt.Println(sts.New(sess).GetCallerIdentity(&sts.GetCallerIdentityInput{}))

	sess = session.Must(session.NewSession(aws.NewConfig().WithCredentials(stscreds.NewCredentials(sess, *sourceRoleARN))))
	fmt.Println(sts.New(sess).GetCallerIdentity(&sts.GetCallerIdentityInput{}))

	sess = session.Must(session.NewSession(aws.NewConfig().WithCredentials(stscreds.NewCredentials(sess, *destRoleARN))))
	fmt.Println(sts.New(sess).GetCallerIdentity(&sts.GetCallerIdentityInput{}))
}
