// SHARED PROFILE FILE

locals { shared_creds_file = "./aws_creds" }
variable "source_profile" { type = string }
variable "dest_profile" { type = string }

// SOURCE ROLE

provider "aws" {
  shared_credentials_file = local.shared_creds_file
  profile                 = var.source_profile
  region                  = "us-west-2"
  alias                   = "source_account"
}

data "aws_caller_identity" "source_account" {
  provider = aws.source_account
}

data "aws_iam_policy_document" "source_role_trust_doc" {
  provider = aws.source_account
  statement {
    effect = "Allow"
    principals {
      identifiers = [data.aws_caller_identity.source_account.account_id]
      type        = "AWS"
    }
    actions = ["sts:AssumeRole"]
  }
}

resource "aws_iam_role" "source_role" {
  provider           = aws.source_account
  name               = "VIDTOOL_source_role"
  assume_role_policy = data.aws_iam_policy_document.source_role_trust_doc.json
}

module "video_organization_principal_source" {
  providers     = { aws = aws.source_account }
  source        = "git::git+ssh://git@git-aws.internal.justin.tv/terraform-modules/video-organization-principal.git//source"
  iam_role_name = aws_iam_role.source_role.name
}


// DESTINATION ROLE

provider "aws" {
  shared_credentials_file = local.shared_creds_file
  profile                 = var.dest_profile
  region                  = "us-west-2"
  alias                   = "dest_account"
}

module "video_org_principal_destination" {
  providers = { aws = aws.dest_account }
  source    = "git::git+ssh://git@git-aws.internal.justin.tv/terraform-modules/video-organization-principal.git//destination"
}

resource "aws_iam_role" "dest_role" {
  provider           = aws.dest_account
  name               = "VIDTOOL_dest_role"
  assume_role_policy = module.video_org_principal_destination.policy.json
}
