variable "iam_role_name" {
  type        = string
  description = "The name of the IAM-Role to designate as a generalize AssumeRole source."
}

data "aws_iam_policy_document" "assumerole_source_policy_statement" {
  statement {
    effect    = "Allow"
    actions   = ["sts:AssumeRole"]
    resources = ["*"]
    // TODO: Ask AWS support if there is a condition-key we can use to restrict
    // this to roles within the organization.
  }
}

resource "aws_iam_policy" "assumerole_source_policy" {
  name_prefix = "VidTools-Generalized-AssumeRole-Source"
  policy      = data.aws_iam_policy_document.assumerole_source_policy_statement.json
  description = "Allow sts:AssumeRole calls from this IAM-Role to to any other IAM-Role. Destination IAM-Role must still explicitly allow this source IAM-Role to reach it. This allows VidCS to onboard to Milliner by giving them AssumeRole access from a host's IAM-Role to their maintenance IAM-Roles."
}

resource "aws_iam_role_policy_attachment" "assumerole_source_attachment" {
  role       = var.iam_role_name
  policy_arn = aws_iam_policy.assumerole_source_policy.arn
}
