package httpapi

import (
	"net/http"

	"code.justin.tv/hygienic/basehttpserver"
	"code.justin.tv/sse/malachai/pkg/s2s/callee"
	"code.justin.tv/timotyenorg/timotyenapp/proto/timotyenapp"
)

// HTTPServer exposes our twirp service
type HTTPServer struct {
	basehttpserver.HTTPServer
	TimotyenappServer timotyenapp.TwirpServer
	S2SClient         *callee.Client
}

// Setup registers all the HTTPHandlers on the server's mux
func (h *HTTPServer) Setup() error {
	handler := http.Handler(h.TimotyenappServer)
	if h.S2SClient != nil {
		handler = h.S2SClient.RequestValidatorMiddleware(h.TimotyenappServer)
	}
	h.Mux.Handle(timotyenapp.TimotyenappPathPrefix, handler)
	return h.HTTPServer.Setup()
}
