package twirptimotyenapp

import (
	"context"
	"testing"

	"code.justin.tv/timotyenorg/timotyenapp/proto/timotyenapp"
)

func TestTimotyenappImpl_ItemGet(t *testing.T) {
	e := TimotyenappImpl{
		SecretKey: "hi",
	}
	resp, err := e.ItemGet(context.Background(), &timotyenapp.ItemGetRequest{
		Key: "hi",
	})
	if err != nil {
		t.Error("expected no error")
	}
	if resp.Value != "YOU GUESSED THE SECRET KEY" {
		t.Error("You should be able to guess the secret key")
	}
}

func TestTimotyenappImpl_ItemError(t *testing.T) {
	e := TimotyenappImpl{
		SecretKey: "hi",
	}
	_, err := e.ItemGet(context.Background(), &timotyenapp.ItemGetRequest{
		Key: "-downstream_failure-",
	})
	if err == nil {
		t.Error("expected an error")
	}
}
