#!/bin/bash

TWINIT_SSH_HOST=${TWINIT_SSH_HOST:-"dta-twinit-services-proxy-prod.internal.justin.tv"}
TWINIT_SSH_USER=${TWINIT_SSH_USER:-"${USER-$(whoami)}"}
TWINIT_TUNNEL_LOCAL_HOST=${TWINIT_TUNNEL_LOCAL_HOST:-"127.0.0.1"}
TWINIT_TUNNEL_LOCAL_PORT=${TWINIT_TUNNEL_LOCAL_PORT:-"12345"}
TWINIT_TUNNEL_REMOTE_HOST=${TWINIT_TUNNEL_REMOTE_HOST:-"127.0.0.1"}
TWINIT_TUNNEL_REMOTE_PORT=${TWINIT_TUNNEL_REMOTE_PORT:-"80"}
TWINIT_NO_PROXY=${TWINIT_NO_PROXY:-"*.test.example.com,.example2.com"}
# Read in any override variables
if [[ -r ~/.twinit/config.sh ]] ; then
  . ~/.twinit/config.sh
fi

if_err_exit() {
  err=$1
  msg=$2
  exitno=${3-}
  exitno=${exitno:-"1"}
  if [ $err -ne 0 ] ; then
    echo $msg
    exit $exitno
  fi
}

function root__twinit() {
  if [[ "${1-}" == "help" ]]; then
    echo "Run twinit related commands: this allows access to devtools resources"
    exit 0
  fi
  process_build twinit__ $@
}

function twinit__enable() {
  if [[ "${1-}" == "help" ]]; then
    echo "Enable the twinit tunnel"
    exit 0
  fi
  mkdir -p ~/.twinit
  if kstatus; then
    echo "ssh port tunnel already enabled"
  else
    echo "Checking on teleport-bastion"
    teleport_location=`which teleport-bastion`
    if_err_exit $? "Could not find teleport-bastion tool in our path!"
    echo "Found teleport tool: ${teleport_location} "
    ${teleport_location} status | grep enabled > /dev/null
    if_err_exit $?  "teleport-bastion is not enabled.  Please enable it before running this tool."
    echo "Starting up ssh port tunnel in background"
    ssh -fN \
      -MS ~/.twinit/sshsocket \
      -L ${TWINIT_TUNNEL_LOCAL_HOST}:${TWINIT_TUNNEL_LOCAL_PORT}:${TWINIT_TUNNEL_REMOTE_HOST}:${TWINIT_TUNNEL_REMOTE_PORT} ${TWINIT_SSH_USER}@${TWINIT_SSH_HOST}
  fi
}

function twinit__disable() {
  if [[ "${1-}" == "help" ]]; then
    echo "Disable the twinit tunnel"
    exit 0
  fi
  mkdir -p ~/.twinit
  if kstatus; then
    echo "Stopping existing ssh tunnel"
    ssh -S ~/.twinit/sshsocket -O exit $TWINIT_TUNNEL_REMOTE_HOST
  fi
}

