package httpapi

import (
	"net/http"

	"code.justin.tv/hygienic/basehttpserver"
	"code.justin.tv/sse/malachai/pkg/s2s/callee"
	"code.justin.tv/timotyenorg/timotyenservice/proto/timotyenservice"
)

// HTTPServer exposes our twirp service
type HTTPServer struct {
	basehttpserver.HTTPServer
	TimotyenserviceServer timotyenservice.TwirpServer
	S2SClient             *callee.Client
}

// Setup registers all the HTTPHandlers on the server's mux
func (h *HTTPServer) Setup() error {
	handler := http.Handler(h.TimotyenserviceServer)
	if h.S2SClient != nil {
		handler = h.S2SClient.RequestValidatorMiddleware(h.TimotyenserviceServer)
	}
	h.Mux.Handle(timotyenservice.TimotyenservicePathPrefix, handler)
	return h.HTTPServer.Setup()
}
